<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Function to sanitize input data
    function sanitize_input($data) {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }

    // Collect and sanitize form data
    $name = sanitize_input($_POST['name']);
    $number = sanitize_input($_POST['number']);
    $pincode = sanitize_input($_POST['pincode']);

    // Basic server-side validation
    $errors = [];

    // Validate name (only letters and whitespace)
    if (!preg_match("/^[a-zA-Z ]*$/", $name)) {
        $errors[] = "Only letters and white space allowed in Name.";
    }

    // Validate number (exactly 10 digits)
    if (!preg_match("/^\d{10}$/", $number)) {
        $errors[] = "Number must be exactly 10 digits.";
    }

    // Validate pincode (exactly 6 digits)
    if (!preg_match("/^\d{6}$/", $pincode)) {
        $errors[] = "Pincode must be exactly 6 digits.";
    }

    if (empty($errors)) {
        // Set up email parameters
        $to = "errajkumartailor@gmail.com,leads@apptechinfosoft.com"; // Replace with the recipient's email address
        $subject = "New Form Submission";
        $message = "You have received a new form submission:\n\n" .
                   "Name: $name\n" .
                   "Number: $number\n" .
                   "Pincode: $pincode\n";

        // Email headers
        $headers = "From: no-reply@dnnriadmission.online\r\n" . // Replace with a valid sender email
                   "Reply-To: no-reply@dnnriadmission.online\r\n" .
                   "X-Mailer: PHP/" . phpversion();

        // Send email
        if (mail($to, $subject, $message, $headers)) {
            // Success message
            echo "<!DOCTYPE html>
            <html lang='en'>
            <head>
                <meta charset='UTF-8'>
                <title>Submission Successful</title>
            </head>
            <body>
                <h2>Thank you!</h2>
                <p>Your information has been submitted successfully.</p>
            </body>
            </html>";
        } else {
            // Failure message
            echo "<!DOCTYPE html>
            <html lang='en'>
            <head>
                <meta charset='UTF-8'>
                <title>Submission Failed</title>
            </head>
            <body>
                <h2>Oops!</h2>
                <p>There was an error sending your information. Please try again later.</p>
            </body>
            </html>";
        }
    } else {
        // Display errors
        echo "<!DOCTYPE html>
        <html lang='en'>
        <head>
            <meta charset='UTF-8'>
            <title>Form Errors</title>
        </head>
        <body>
            <h2>There were errors with your submission:</h2>
            <ul>";
        foreach ($errors as $error) {
            echo "<li>" . htmlspecialchars($error) . "</li>";
        }
        echo "</ul>
            <p>Please go back and correct these errors.</p>
        </body>
        </html>";
    }
} else {
    // If the form was not submitted via POST
    header("Location: https://waterpurifier-experts.co.in/"); // Redirect to the form page
    exit();
}
?>
